/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.mixin;

import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationConfig;
import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationNoiseCondition;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRarity;
import com.github.alexmodguy.alexscaves.server.level.biome.BiomeSourceAccessor;
import com.github.alexmodguy.alexscaves.server.level.biome.MultiNoiseBiomeSourceAccessor;
import com.github.alexmodguy.alexscaves.server.misc.VoronoiGenerator;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiNoiseBiomeSource.class}, priority=-69420)
public class MultiNoiseBiomeSourceMixin
implements MultiNoiseBiomeSourceAccessor {
    private long lastSampledWorldSeed;
    private ResourceKey<Level> lastSampledDimension;

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/level/biome/MultiNoiseBiomeSource;getNoiseBiome(IIILnet/minecraft/world/level/biome/Climate$Sampler;)Lnet/minecraft/core/Holder;"}, cancellable=true)
    private void citadel_getNoiseBiomeCoords(int x, int y, int z, Climate.Sampler sampler, CallbackInfoReturnable<Holder<Biome>> cir) {
        VoronoiGenerator.VoronoiInfo voronoiInfo = ACBiomeRarity.getRareBiomeInfoForQuad(this.lastSampledWorldSeed, x, z);
        if (voronoiInfo != null) {
            float unquantizedDepth = Climate.m_186796_((long)sampler.m_183445_(x, y, z).f_187007_());
            int foundRarityOffset = ACBiomeRarity.getRareBiomeOffsetId(voronoiInfo);
            for (Map.Entry<ResourceKey<Biome>, BiomeGenerationNoiseCondition> condition : BiomeGenerationConfig.BIOMES.entrySet()) {
                if (foundRarityOffset != condition.getValue().getRarityOffset() || !condition.getValue().test(x, y, z, unquantizedDepth, sampler, this.lastSampledDimension, voronoiInfo)) continue;
                cir.setReturnValue(((BiomeSourceAccessor)((Object)this)).getResourceKeyMap().get(condition.getKey()));
            }
        }
    }

    @Override
    public void setLastSampledSeed(long seed) {
        this.lastSampledWorldSeed = seed;
    }

    @Override
    public void setLastSampledDimension(ResourceKey<Level> dimension) {
        this.lastSampledDimension = dimension;
    }
}

