/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.MineGuardianAnchorModel;
import com.github.alexmodguy.alexscaves.client.render.entity.BoundroidWinchRenderer;
import com.github.alexmodguy.alexscaves.server.entity.item.MineGuardianAnchorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MineGuardianAnchorRenderer
extends EntityRenderer<MineGuardianAnchorEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves", "textures/entity/mine_guardian_anchor.png");
    private static final ResourceLocation TEXTURE_CHAIN = new ResourceLocation("minecraft:textures/block/chain.png");
    private static final MineGuardianAnchorModel MODEL = new MineGuardianAnchorModel();

    public MineGuardianAnchorRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public boolean shouldRender(MineGuardianAnchorEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Entity)entity, camera, x, y, z)) {
            return true;
        }
        Entity guardian = entity.getGuardian();
        if (guardian != null) {
            Vec3 vec3 = entity.m_20182_();
            Vec3 vec31 = guardian.m_20182_();
            return camera.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    public void render(MineGuardianAnchorEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)1.35f, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_())));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_()) + 180.0f));
        MODEL.setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        MODEL.m_7695_(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.m_85849_();
        Vec3 translateFrom = entity.m_20318_(partialTicks);
        Vec3 modelOffset = MODEL.getChainPosition(new Vec3(0.0, (double)0.1f, 0.0));
        Vec3 chainTo = entity.getChainFrom(partialTicks).m_82549_(modelOffset).m_82546_(translateFrom);
        Vec3 chainFrom = entity.getChainTo(partialTicks).m_82546_(translateFrom).m_82546_(chainTo);
        VertexConsumer chainBuffer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_CHAIN));
        poseStack.m_85836_();
        poseStack.m_85837_(chainTo.f_82479_, chainTo.f_82480_, chainTo.f_82481_);
        BoundroidWinchRenderer.renderChain(chainFrom, poseStack, chainBuffer, packedLightIn, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(MineGuardianAnchorEntity entity) {
        return TEXTURE;
    }
}

