/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.GossamerWormModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.GossamerWormEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.entity.PartEntity;

public class GossamerWormRenderer
extends MobRenderer<GossamerWormEntity, GossamerWormModel>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/gossamer_worm.png");
    private boolean sepia;

    public GossamerWormRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new GossamerWormModel(), 0.9f);
    }

    public boolean shouldRender(GossamerWormEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Mob)entity, camera, x, y, z)) {
            return true;
        }
        for (PartEntity<?> part : entity.getParts()) {
            if (!camera.m_113029_(part.m_6921_())) continue;
            return true;
        }
        return false;
    }

    public void render(GossamerWormEntity entity, float f1, float partialTicks, PoseStack poseStack, MultiBufferSource source, int light) {
        ((GossamerWormModel)this.f_115290_).straighten = this.sepia;
        super.m_7392_((Mob)entity, f1, partialTicks, poseStack, source, light);
    }

    @Nullable
    protected RenderType getRenderType(GossamerWormEntity gossamerWorm, boolean normal, boolean translucent, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(gossamerWorm);
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return this.sepia ? ACRenderTypes.getBookWidget(resourcelocation, true) : ACRenderTypes.getGhostly(resourcelocation);
        }
        return outline ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    public ResourceLocation getTextureLocation(GossamerWormEntity entity) {
        return TEXTURE;
    }
}

