/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SleepParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private float yRotAngle = 0.0f;
    private float rotations;
    private static final Vec3 ROTATE_BY = new Vec3(1.0, 0.0, 0.0);

    protected SleepParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = spriteSet;
        this.yRotAngle = (float)(Math.PI * 2 * (double)this.f_107223_.m_188501_());
        this.rotations = this.f_107223_.m_188501_() * 5.0f + 5.0f;
        this.m_108339_(this.sprites);
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.m_107250_(0.5f, 0.5f);
        this.f_107663_ = 0.1f + world.f_46441_.m_188501_() * 0.1f;
        this.f_107225_ = 10 + world.f_46441_.m_188503_(20);
        this.f_172258_ = 0.95f;
    }

    public void m_5989_() {
        super.m_5989_();
        float ageLerp = (float)this.f_107224_ / (float)this.f_107225_;
        this.f_107663_ = Math.max(0.0f, this.f_107663_ - 0.008f);
        Vec3 vec3 = ROTATE_BY.m_82524_(this.yRotAngle + this.rotations * ageLerp);
        this.f_107215_ += vec3.f_82479_ * 0.05;
        this.f_107217_ += vec3.f_82481_ * 0.05;
        this.m_108339_(this.sprites);
        this.f_107215_ *= 0.8;
        this.f_107217_ *= 0.8;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SleepParticle particle = new SleepParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            return particle;
        }
    }
}

