/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.render.entity.ForsakenRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.ForsakenEntity;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ForsakenSonarParticle
extends TextureSheetParticle {
    private final int forsakenId;
    private float xRot;
    private float yRot;
    private float fadeR;
    private float fadeG;
    private float fadeB;
    private boolean massive;
    private boolean passedTarget;

    protected ForsakenSonarParticle(ClientLevel world, double x, double y, double z, int entityId, float xRot, float yRot, boolean massive) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.m_107250_(massive ? 2.99f : 0.9f, 0.99f);
        this.m_107253_(1.0f, 1.0f, 1.0f);
        this.forsakenId = entityId;
        this.massive = massive;
        this.f_107225_ = 15;
        this.setInMouthPos(1.0f);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107663_ = massive ? 3.0f + world.f_46441_.m_188501_() * 0.5f : 1.0f + world.f_46441_.m_188501_() * 0.3f;
        this.f_172258_ = 1.0f;
        this.xRot = xRot;
        this.yRot = yRot;
        this.setFadeColor(0xE60000);
        this.angleTowardsTarget();
    }

    public void setFadeColor(int i) {
        this.fadeR = (float)((i & 0xFF0000) >> 16) / 255.0f;
        this.fadeG = (float)((i & 0xFF00) >> 8) / 255.0f;
        this.fadeB = (float)((i & 0xFF) >> 0) / 255.0f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        float f = ((float)this.f_107224_ - (float)(this.f_107225_ / 2)) / (float)this.f_107225_;
        float f1 = (float)this.f_107224_ / (float)this.f_107225_;
        float f2 = 1.0f - 0.1f * f1;
        this.f_172258_ = 1.0f - 0.65f * f1;
        if (this.f_107224_ > this.f_107225_ / 2) {
            this.m_107271_(1.0f - f * 2.0f);
        }
        this.angleTowardsTarget();
        this.f_107227_ += (this.fadeR - this.f_107227_) * 0.1f;
        this.f_107228_ += (this.fadeG - this.f_107228_) * 0.1f;
        this.f_107229_ += (this.fadeB - this.f_107229_) * 0.1f;
        Vec3 motionVec = new Vec3(0.0, 0.0, this.massive ? (double)-0.2f : 0.5).m_82496_((float)Math.toRadians(this.xRot)).m_82524_(-((float)Math.toRadians(this.yRot)));
        this.f_107215_ += motionVec.f_82479_ * (double)f2;
        this.f_107216_ += motionVec.f_82480_ * (double)f2;
        this.f_107217_ += motionVec.f_82481_ * (double)f2;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= (double)this.f_172258_;
            this.f_107216_ *= (double)this.f_172258_;
            this.f_107217_ *= (double)this.f_172258_;
        }
    }

    public void setInMouthPos(float partialTick) {
        Entity entity;
        if (this.forsakenId != -1 && (entity = this.f_107208_.m_6815_(this.forsakenId)) instanceof ForsakenEntity) {
            ForsakenEntity entity2 = (ForsakenEntity)entity;
            Vec3 mouthPos = ForsakenRenderer.getMouthPositionFor(this.forsakenId);
            if (mouthPos != null) {
                Vec3 translate = mouthPos.m_82549_(new Vec3(0.0, this.massive ? 0.75 : 0.0, 0.0)).m_82524_((float)(Math.PI - (double)(entity2.f_20883_ * ((float)Math.PI / 180))));
                this.m_107264_(entity2.m_20185_() + translate.f_82479_, entity2.m_20186_() + translate.f_82480_, entity2.m_20189_() + translate.f_82481_);
            }
            if (!this.massive) {
                Entity target = entity2.getSonarTarget();
                this.f_107225_ = target == null ? 40 : 15 + Math.min(15, (int)Math.ceil(entity2.m_20270_(target) * 3.0f));
            }
        }
    }

    public void angleTowardsTarget() {
        ForsakenEntity forsakenEntity;
        Entity target;
        Entity entity;
        if (!this.massive && this.forsakenId != -1 && !this.passedTarget && (entity = this.f_107208_.m_6815_(this.forsakenId)) instanceof ForsakenEntity && (target = (forsakenEntity = (ForsakenEntity)entity).getSonarTarget()) != null) {
            Vec3 vector3d1 = target.m_146892_().m_82492_(this.f_107212_, this.f_107213_, this.f_107214_);
            if (vector3d1.m_82553_() < 2.0) {
                this.passedTarget = true;
            }
            this.yRot = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f;
            this.xRot = (float)(Mth.m_14136_((double)vector3d1.f_82480_, (double)vector3d1.m_165924_()) * 57.2957763671875);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float partialTicks) {
        return 240;
    }

    public float m_5902_(float scaleFactor) {
        float f = this.massive ? 4.0f : 2.0f;
        float f1 = this.massive ? 1.0f : 1.5f;
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + scaleFactor) * f1 / (float)this.f_107225_), (float)0.0f, (float)1.0f) * f;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        this.renderSignal(vertexConsumer, camera, partialTick, quaternionf -> quaternionf.rotateY(-((float)Math.toRadians(this.yRot))).rotateX(-((float)Math.toRadians(this.xRot))));
        this.renderSignal(vertexConsumer, camera, partialTick, quaternionf -> quaternionf.rotateY((float)(-Math.PI) - (float)Math.toRadians(this.yRot)).rotateX((float)Math.toRadians(this.xRot)));
    }

    private void renderSignal(VertexConsumer consumer, Camera camera, float partialTicks, Consumer<Quaternionf> rots) {
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Vector3f vector3f = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, vector3f.x(), vector3f.y(), vector3f.z());
        rots.accept(quaternionf);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f1 = avector3f[i];
            vector3f1.rotate((Quaternionfc)quaternionf);
            vector3f1.mul(f3);
            vector3f1.add(f, f1, f2);
        }
        float f6 = this.m_5970_();
        float f7 = this.m_5952_();
        float f4 = this.m_5951_();
        float f5 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        consumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        consumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f7, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        consumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f6, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        consumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f6, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LargeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public LargeFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ForsakenSonarParticle particle = new ForsakenSonarParticle(worldIn, x, y, z, (int)xSpeed, (float)ySpeed, (float)zSpeed, true);
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ForsakenSonarParticle particle = new ForsakenSonarParticle(worldIn, x, y, z, (int)xSpeed, (float)ySpeed, (float)zSpeed, false);
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }
}

