/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.dawson.adorablehamsterpets.mixin.accessor.ScreenWidgetAdder;
import net.dawson.adorablehamsterpets.mixin.client.accessor.ClickableWidgetAccessor;
import net.dawson.adorablehamsterpets.mixin.client.accessor.GuiBookAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntryList;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.common.book.Book;

@Mixin(value={GuiBookEntryList.class}, remap=false)
public abstract class GuiBookEntryListMixin
extends GuiBook {
    @Shadow
    @Final
    protected List<Button> entryButtons;
    @Shadow
    @Final
    private List<BookEntry> visibleEntries;
    @Shadow
    private List<BookEntry> allEntries;
    @Shadow
    private EditBox searchField;

    @Shadow
    protected abstract void addSubcategoryButtons();

    public GuiBookEntryListMixin(Book book, Component title) {
        super(book, title);
    }

    private boolean isHamsterBook() {
        return this.book != null && this.book.id.equals((Object)ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"));
    }

    @Inject(method={"buildEntryButtons"}, at={@At(value="HEAD")}, cancellable=true)
    private void adorablehamsterpets$buildWrappedEntryButtons(CallbackInfo ci) {
        if (!this.isHamsterBook()) {
            return;
        }
        ci.cancel();
        GuiBookAccessor accessor = (GuiBookAccessor)((Object)this);
        this.removeDrawablesIn(this.entryButtons);
        this.entryButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.m_94155_().toLowerCase();
        Stream<BookEntry> stream = this.allEntries.stream().filter(e -> e.isFoundByQuery(query));
        Objects.requireNonNull(this.visibleEntries);
        stream.forEach(this.visibleEntries::add);
        ArrayList<Integer> pageStartIndices = new ArrayList<Integer>();
        if (!this.visibleEntries.isEmpty()) {
            pageStartIndices.add(0);
            Font textRenderer = Minecraft.m_91087_().f_91062_;
            int availableWidth = 104;
            int firstPageHeightLimit = 118;
            int subsequentPageHeightLimit = 138;
            int currentEntryIndex = 0;
            boolean isFirstPage = true;
            while (currentEntryIndex < this.visibleEntries.size()) {
                BookEntry entry;
                MutableComponent name;
                int buttonHeight;
                int pageHeightLimit = isFirstPage ? firstPageHeightLimit : subsequentPageHeightLimit;
                int currentY = 0;
                while (currentEntryIndex < this.visibleEntries.size() && currentY + (buttonHeight = textRenderer.m_92923_((FormattedText)(name = (entry = this.visibleEntries.get(currentEntryIndex)).isLocked() ? Component.m_237115_((String)"patchouli.gui.lexicon.locked") : entry.getName().m_6881_()), availableWidth).size() * 10) <= pageHeightLimit) {
                    currentY += buttonHeight + 1;
                    ++currentEntryIndex;
                }
                if (isFirstPage) {
                    isFirstPage = false;
                } else {
                    currentY = 0;
                    while (currentEntryIndex < this.visibleEntries.size() && currentY + (buttonHeight = textRenderer.m_92923_((FormattedText)(name = (entry = this.visibleEntries.get(currentEntryIndex)).isLocked() ? Component.m_237115_((String)"patchouli.gui.lexicon.locked") : entry.getName().m_6881_()), availableWidth).size() * 10) <= pageHeightLimit) {
                        currentY += buttonHeight + 1;
                        ++currentEntryIndex;
                    }
                }
                if (currentEntryIndex >= this.visibleEntries.size()) continue;
                pageStartIndices.add(currentEntryIndex);
            }
        }
        int numPages = pageStartIndices.size();
        accessor.adorablehamsterpets$setMaxSpreads(1 + (int)Math.ceil((double)(numPages - 1) / 2.0));
        if (accessor.adorablehamsterpets$getMaxSpreads() < 1) {
            accessor.adorablehamsterpets$setMaxSpreads(1);
        }
        if (accessor.adorablehamsterpets$getSpread() >= accessor.adorablehamsterpets$getMaxSpreads()) {
            accessor.adorablehamsterpets$setSpread(Math.max(0, accessor.adorablehamsterpets$getMaxSpreads() - 1));
        }
        if (accessor.adorablehamsterpets$getSpread() == 0) {
            int start = pageStartIndices.isEmpty() ? 0 : (Integer)pageStartIndices.get(0);
            int end = numPages > 1 ? ((Integer)pageStartIndices.get(1)).intValue() : this.visibleEntries.size();
            this.addWrappedEntryButtons(141, 38, start, end - start);
            this.addSubcategoryButtons();
        } else {
            int leftPageIndex = accessor.adorablehamsterpets$getSpread() * 2 - 1;
            int rightPageIndex = accessor.adorablehamsterpets$getSpread() * 2;
            int leftStartIndex = numPages > leftPageIndex ? ((Integer)pageStartIndices.get(leftPageIndex)).intValue() : this.visibleEntries.size();
            int rightStartIndex = numPages > rightPageIndex ? ((Integer)pageStartIndices.get(rightPageIndex)).intValue() : this.visibleEntries.size();
            int leftCount = rightStartIndex - leftStartIndex;
            this.addWrappedEntryButtons(15, 18, leftStartIndex, leftCount);
            this.addWrappedEntryButtons(141, 18, rightStartIndex, this.visibleEntries.size() - rightStartIndex);
        }
    }

    private void addWrappedEntryButtons(int x, int y, int start, int count) {
        int entryIndex;
        GuiBookEntryList self = (GuiBookEntryList)this;
        GuiBookAccessor accessor = (GuiBookAccessor)self;
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        int bookLeft = accessor.adorablehamsterpets$getBookLeft();
        int bookTop = accessor.adorablehamsterpets$getBookTop();
        int availableWidth = 104;
        int yOffset = y;
        for (int i = 0; i < count && (entryIndex = start + i) < this.visibleEntries.size(); ++i) {
            BookEntry entry = this.visibleEntries.get(entryIndex);
            MutableComponent name = entry.isLocked() ? Component.m_237115_((String)"patchouli.gui.lexicon.locked") : entry.getName().m_6881_();
            int buttonHeight = textRenderer.m_92923_((FormattedText)name, availableWidth).size() * 10;
            GuiButtonEntry button = new GuiButtonEntry((GuiBook)self, bookLeft + x, bookTop + yOffset, entry, arg_0 -> ((GuiBookEntryList)self).handleButtonEntry(arg_0));
            ((ClickableWidgetAccessor)button).adorablehamsterpets$setHeight(buttonHeight);
            ((ScreenWidgetAdder)self).adorablehamsterpets$addWidget(button);
            this.entryButtons.add((Button)button);
            yOffset += buttonHeight + 1;
        }
    }
}

