/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.integration.jade;

import java.util.Optional;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum HamsterBedComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag serverData = accessor.getServerData();
        RegistryAccess registryLookup = accessor.getLevel().m_9598_();
        Player player = accessor.getPlayer();
        if (serverData.m_128441_("LinkedHamsterName")) {
            boolean isWanderActive;
            MutableComponent hamsterName = Component.Serializer.m_130701_((String)serverData.m_128461_("LinkedHamsterName"));
            if (hamsterName != null) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.adorablehamsterpets.hamster_bed.linked_to", (Object[])new Object[]{hamsterName}).m_130940_(ChatFormatting.GREEN));
            }
            MutableComponent wanderStatus = (isWanderActive = serverData.m_128471_("WanderModeActive")) ? Component.m_237113_((String)"ACTIVE").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"INACTIVE").m_130940_(ChatFormatting.RED);
            WanderDistance distance = WanderDistance.valueOf(serverData.m_128461_("WanderDistance").toUpperCase());
            int radius = switch (distance) {
                case WanderDistance.NEAR -> (Integer)Configs.AHP.wanderDistanceNear.get();
                case WanderDistance.FAR -> (Integer)Configs.AHP.wanderDistanceFar.get();
                default -> (Integer)Configs.AHP.wanderDistanceMedium.get();
            };
            tooltip.add((Component)Component.m_237110_((String)"tooltip.adorablehamsterpets.jade.wander_status", (Object[])new Object[]{wanderStatus, distance.m_7912_(), radius}));
            if (player.m_6144_()) {
                boolean allowSleep = serverData.m_128471_("AllowSleepInBed");
                MutableComponent sleepStatus = allowSleep ? Component.m_237113_((String)"TRUE").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"FALSE").m_130940_(ChatFormatting.RED);
                tooltip.add((Component)Component.m_237110_((String)"tooltip.adorablehamsterpets.jade.sleep_status", (Object[])new Object[]{sleepStatus}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.jade.wander_controls").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.jade.lure_hint").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.jade.repellent_hint").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.jade.unlink_hint").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.sneak_for_info").m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.adorablehamsterpets.jade.unlinked").m_130940_(ChatFormatting.GOLD));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)blockEntity;
            Player player = accessor.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ServerLevel serverWorld = player2.m_284548_();
                Optional<Component> liveName = bedEntity.getLinkedHamsterUuid().map(arg_0 -> ((ServerLevel)serverWorld).m_8791_(arg_0)).filter(e -> e instanceof HamsterEntity).map(entity -> {
                    HamsterEntity hamster = (HamsterEntity)entity;
                    if (hamster.m_8077_()) {
                        return hamster.m_7755_();
                    }
                    return hamster.m_5446_().m_6881_().m_130946_(" " + hamster.m_19879_());
                });
                Component nameToShow = liveName.or(bedEntity::getLinkedHamsterName).orElse(null);
                if (nameToShow != null) {
                    data.m_128359_("LinkedHamsterName", Component.Serializer.m_130703_((Component)nameToShow));
                }
            }
            data.m_128379_("WanderModeActive", bedEntity.isWanderModeActive());
            data.m_128359_("WanderDistance", bedEntity.getWanderDistance().m_7912_());
            data.m_128379_("AllowSleepInBed", bedEntity.isSleepingAllowed());
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }

    static {
        UID = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"hamster_bed_info");
    }
}

