/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.client.sound.HamsterCleaningSoundInstance;
import net.dawson.adorablehamsterpets.entity.client.HamsterModel;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterOverlayLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterPinkPetalOverlayLayer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HamsterRenderer
extends GeoEntityRenderer<HamsterEntity> {
    private final float adultShadowRadius;
    private static final Map<Integer, HamsterCleaningSoundInstance> activeCleaningSounds = new HashMap<Integer, HamsterCleaningSoundInstance>();

    public HamsterRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new HamsterModel());
        this.f_114477_ = this.adultShadowRadius = 0.2f;
        this.addRenderLayer(new HamsterOverlayLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterPinkPetalOverlayLayer((GeoRenderer<HamsterEntity>)this));
    }

    public ResourceLocation getTextureLocation(HamsterEntity entity) {
        HamsterVariant variant = HamsterVariant.byId(entity.getVariant());
        String baseTextureName = variant.getBaseTextureName();
        return ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)("textures/entity/hamster/" + baseTextureName + ".png"));
    }

    public void render(HamsterEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        AnimatableManager manager;
        AnimatableInstanceCache cache;
        boolean isCleaning = entity.isCleaning();
        HamsterCleaningSoundInstance sound = activeCleaningSounds.get(entity.m_19879_());
        if (isCleaning && (sound == null || sound.m_7801_())) {
            sound = new HamsterCleaningSoundInstance(entity);
            activeCleaningSounds.put(entity.m_19879_(), sound);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        } else if (!isCleaning && sound != null) {
            sound.stop();
            activeCleaningSounds.remove(entity.m_19879_());
        }
        this.f_114477_ = entity.m_6162_() ? this.adultShadowRadius * 0.5f : this.adultShadowRadius;
        AdorableHamsterPetsClient.onHamsterRendered(entity.m_19879_());
        poseStack.m_85836_();
        float targetYOffset = 0.0f;
        BlockPos pos = entity.m_20183_();
        BlockState blockState = entity.m_9236_().m_8055_(pos);
        if (blockState.m_60713_(Blocks.f_50125_)) {
            targetYOffset = 0.125f;
        }
        entity.renderedSnowYOffset += (targetYOffset - entity.renderedSnowYOffset) * 0.15f;
        poseStack.m_85837_(0.0, (double)entity.renderedSnowYOffset, 0.0);
        if (!entity.isShoulderPet() && (cache = entity.getAnimatableInstanceCache()) != null && (manager = cache.getManagerForId((long)entity.m_19879_())) != null) {
            manager.updatedAt(0.0);
        }
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }

    public void preRender(PoseStack poseStack, HamsterEntity animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        model.getBone("left_foot").ifPresent(bone -> bone.setTrackingMatrices(true));
        model.getBone("nose").ifPresent(bone -> bone.setTrackingMatrices(true));
    }

    public void renderFinal(PoseStack poseStack, HamsterEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.particleEffectId != null) {
            RandomSource random = animatable.m_217043_();
            switch (animatable.particleEffectId) {
                case "attack_poof": {
                    model.getBone("left_foot").ifPresent(bone -> {
                        Vector3d pos = bone.getWorldPosition();
                        for (int i = 0; i < 8; ++i) {
                            double d = random.m_188583_() * 0.1;
                            double e = random.m_188583_() * 0.2;
                            double f = random.m_188583_() * 0.1;
                            animatable.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.x + d, pos.y + e, pos.z + f, random.m_188583_() * 0.05, random.m_188583_() * 0.05, random.m_188583_() * 0.05);
                        }
                    });
                    break;
                }
                case "seeking_dust": {
                    model.getBone("nose").ifPresent(bone -> {
                        Vector3d pos = bone.getWorldPosition();
                        BlockPos blockBelow = BlockPos.m_274561_((double)pos.x, (double)(pos.y - 0.1), (double)pos.z).m_7495_();
                        BlockState state = animatable.m_9236_().m_8055_(blockBelow);
                        if (state.m_60795_()) {
                            state = Blocks.f_50493_.m_49966_();
                        }
                        for (int i = 0; i < 12; ++i) {
                            double d = random.m_188583_() * 0.2;
                            double e = random.m_188583_() * 0.03;
                            double f = random.m_188583_() * 0.2;
                            animatable.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), pos.x + d, pos.y + e, pos.z + f, 0.0, 0.0, 0.0);
                        }
                    });
                }
            }
            animatable.particleEffectId = null;
        }
        if (animatable.soundEffectId != null) {
            Minecraft client = Minecraft.m_91087_();
            switch (animatable.soundEffectId) {
                case "hamster_step_sound": {
                    BlockPos pos = animatable.m_20183_();
                    BlockState blockState = animatable.m_9236_().m_8055_(pos.m_7495_());
                    if (blockState.m_60795_()) {
                        blockState = animatable.m_9236_().m_8055_(pos.m_6625_(2));
                    }
                    if (blockState.m_60795_()) break;
                    SoundType group = blockState.m_60827_();
                    float volume = blockState.m_60713_(Blocks.f_49994_) ? 0.060000002f : 0.1f;
                    client.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(group.m_56776_(), SoundSource.NEUTRAL, volume, group.m_56774_() * 1.5f, animatable.m_217043_(), animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_()));
                    break;
                }
                case "hamster_beg_bounce": {
                    SoundEvent bounceSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BOUNCE_SOUNDS, animatable.m_217043_());
                    if (bounceSound == null) break;
                    float basePitch = animatable.m_6100_();
                    float randomPitchAddition = animatable.m_217043_().m_188501_() * 0.2f;
                    float finalPitch = basePitch * 1.2f + randomPitchAddition;
                    client.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(bounceSound, SoundSource.NEUTRAL, 0.6f, finalPitch, animatable.m_217043_(), animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_()));
                }
            }
            animatable.soundEffectId = null;
        }
    }

    public void renderRecursively(PoseStack poseStack, HamsterEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        ItemStack stolenStack = animatable.getStolenItemStack();
        if (bone.getName().equals("nose") && animatable.isStealingDiamond()) {
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            poseStack.m_85836_();
            poseStack.m_252880_(bone.getPosX(), bone.getPosY(), bone.getPosZ());
            poseStack.m_252781_(new Quaternionf().rotateZ(bone.getRotZ()));
            poseStack.m_252781_(new Quaternionf().rotateY(bone.getRotY()));
            poseStack.m_252781_(new Quaternionf().rotateX(bone.getRotX()));
            poseStack.m_85841_(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
            poseStack.m_252880_(0.0f, 0.22f, -0.4f);
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            poseStack.m_252781_(new Quaternionf(new AxisAngle4f((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f)));
            itemRenderer.m_269128_(stolenStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, packedLight, packedOverlay, poseStack, bufferSource, animatable.m_9236_(), animatable.m_19879_());
            poseStack.m_85849_();
        }
    }
}

