/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.Optional;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleBreadcrumbHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;

public class HamsterGoToBedAndSleepGoal
extends Goal {
    private final HamsterEntity hamster;
    private final Level world;
    private int pounceTicks;
    @Nullable
    private Vec3 pounceStartPos;
    private int startDelay = 0;
    private boolean wasLured = false;
    private int awakeTimer = 0;
    private static final int MIN_START_DELAY_TICKS = 5;
    private static final int MAX_START_DELAY_TICKS = 100;
    private State currentState = State.MOVING_TO_BED;

    public HamsterGoToBedAndSleepGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (!this.hamster.isWanderModeActive() || this.hamster.m_21827_() || !((Boolean)Configs.AHP.allowSleepInBed.get()).booleanValue()) {
            return false;
        }
        Optional<GlobalPos> bedPosOptional = this.hamster.getLinkedBedPos();
        if (bedPosOptional.isEmpty() || this.world.m_46472_() != bedPosOptional.get().m_122640_()) {
            return false;
        }
        BlockPos bedPos = bedPosOptional.get().m_122646_();
        BlockState bedState = this.world.m_8055_(bedPos);
        BlockEntity be = this.world.m_7702_(bedPos);
        if (!(bedState.m_60734_() instanceof HamsterBedBlock) || ((Boolean)bedState.m_61143_((Property)HamsterBedBlock.OCCUPIED)).booleanValue() || !(be instanceof HamsterBedBlockEntity)) {
            return false;
        }
        HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
        if (!bedEntity.isSleepingAllowed()) {
            return false;
        }
        if (this.hamster.getLureToBedTimer() > 0) {
            return true;
        }
        if (bedEntity.isNewlyPlaced()) {
            return true;
        }
        if (this.hamster.getGoToBedCooldown() > 0) {
            return false;
        }
        if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            if (this.awakeTimer > 0) {
                --this.awakeTimer;
                return false;
            }
            return true;
        }
        boolean isSleepTime = (Boolean)Configs.AHP.sleepDuringDay.get() != false ? this.world.m_46461_() : this.world.m_46462_();
        return isSleepTime;
    }

    public void m_8056_() {
        boolean isLured;
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
        this.hamster.setOnTheWayToBed(true);
        if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            int min = (Integer)Configs.AHP.minNapInBedIntervalSeconds.get() * 20;
            int max = (Integer)Configs.AHP.maxNapInBedIntervalSeconds.get() * 20;
            this.awakeTimer = this.hamster.m_217043_().m_216332_(min, max);
        }
        this.wasLured = isLured = this.hamster.getLureToBedTimer() > 0;
        boolean isNewBed = false;
        boolean shouldBypass = this.hamster.shouldBypassNextSleepDelay();
        Optional<GlobalPos> bedPosOpt = this.hamster.getLinkedBedPos();
        if (bedPosOpt.isPresent()) {
            BlockEntity be;
            BlockPos bedPos = bedPosOpt.get().m_122646_();
            if (this.world.m_46472_() == bedPosOpt.get().m_122640_() && (be = this.world.m_7702_(bedPos)) instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                isNewBed = bedEntity.isNewlyPlaced();
            }
        }
        if (isLured || isNewBed || shouldBypass || ((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            this.startDelay = 0;
            if (isLured) {
                this.hamster.setLureToBedTimer(0);
            }
            if (shouldBypass) {
                this.hamster.setBypassNextSleepDelay(false);
            }
        } else {
            this.startDelay = this.hamster.m_217043_().m_216332_(5, 100);
        }
        this.hamster.setGoToBedDelayTicks(this.startDelay);
        this.currentState = State.MOVING_TO_BED;
    }

    public void m_8041_() {
        this.hamster.m_21573_().m_26573_();
        this.currentState = State.MOVING_TO_BED;
        this.pounceStartPos = null;
        this.wasLured = false;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.hamster.setOnTheWayToBed(false);
        this.hamster.setGoToBedDelayTicks(this.startDelay);
    }

    public boolean m_8045_() {
        if (this.hamster.m_21827_() || !this.hamster.isWanderModeActive()) {
            return false;
        }
        Optional<GlobalPos> bedPosOptional = this.hamster.getLinkedBedPos();
        if (bedPosOptional.isEmpty() || this.world.m_46472_() != bedPosOptional.get().m_122640_()) {
            return false;
        }
        BlockPos bedPos = bedPosOptional.get().m_122646_();
        BlockState bedState = this.world.m_8055_(bedPos);
        return bedState.m_60734_() instanceof HamsterBedBlock && (Boolean)bedState.m_61143_((Property)HamsterBedBlock.OCCUPIED) == false;
    }

    public void m_8037_() {
        if (this.startDelay > 0) {
            --this.startDelay;
            this.hamster.setGoToBedDelayTicks(this.startDelay);
            return;
        }
        Optional<GlobalPos> bedPosOptional = this.hamster.getLinkedBedPos();
        if (bedPosOptional.isEmpty()) {
            this.m_8041_();
            return;
        }
        BlockPos bedPos = bedPosOptional.get().m_122646_();
        if (this.currentState == State.MOVING_TO_BED && this.hamster.m_21573_().m_26571_()) {
            this.hamster.m_21573_().m_26519_((double)bedPos.m_123341_() + 0.5, (double)bedPos.m_123342_(), (double)bedPos.m_123343_() + 0.5, 0.75);
        }
        switch (this.currentState) {
            case MOVING_TO_BED: {
                String settleAnimId;
                this.hamster.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)bedPos));
                if (this.wasLured && !this.world.m_5776_() && !this.hamster.m_21573_().m_26571_()) {
                    ParticleBreadcrumbHelper.spawnBreadcrumbs((ServerLevel)this.world, this.hamster.m_21573_().m_26570_());
                }
                if (this.hamster.m_21573_().m_26571_()) {
                    this.m_8041_();
                    return;
                }
                if (!this.hamster.m_20183_().m_123314_((Vec3i)bedPos, 1.2)) break;
                this.hamster.m_21573_().m_26573_();
                this.currentState = State.POUNCING_INTO_BED;
                this.pounceTicks = 5;
                this.pounceStartPos = this.hamster.m_20182_();
                this.hamster.m_20334_(this.hamster.m_20184_().f_82479_, 0.4, this.hamster.m_20184_().f_82481_);
                this.hamster.f_19812_ = true;
                this.hamster.suffocationGracePeriod = 40;
                this.world.m_5594_(null, this.hamster.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, 0.35f, 1.0f + this.hamster.m_217043_().m_188501_() * 0.5f);
                int choice = this.hamster.m_217043_().m_188503_(3);
                this.hamster.m_20088_().m_135381_(HamsterEntity.CURRENT_DEEP_SLEEP_ANIM_ID, (Object)(switch (choice) {
                    case 0 -> {
                        settleAnimId = "anim_hamster_stand_settle_sleep1";
                        yield "anim_hamster_sleep_pose1";
                    }
                    case 1 -> {
                        settleAnimId = "anim_hamster_stand_settle_sleep2";
                        yield "anim_hamster_sleep_pose2";
                    }
                    default -> {
                        settleAnimId = "anim_hamster_stand_settle_sleep3";
                        yield "anim_hamster_sleep_pose3";
                    }
                }));
                this.hamster.triggerAnimOnServer("mainController", settleAnimId);
                break;
            }
            case POUNCING_INTO_BED: {
                --this.pounceTicks;
                this.hamster.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)bedPos));
                if (this.pounceStartPos != null && this.pounceTicks >= 0) {
                    double progress = 1.0 - (double)this.pounceTicks / 5.0;
                    double easedProgress = progress * progress;
                    Vec3 targetCenter = Vec3.m_82512_((Vec3i)bedPos).m_82520_(0.0, 0.1, 0.0);
                    double newX = this.pounceStartPos.f_82479_ + easedProgress * (targetCenter.f_82479_ - this.pounceStartPos.f_82479_);
                    double newZ = this.pounceStartPos.f_82481_ + easedProgress * (targetCenter.f_82481_ - this.pounceStartPos.f_82481_);
                    this.hamster.m_6034_(newX, this.hamster.m_20186_(), newZ);
                }
                if (this.pounceTicks >= 0) break;
                Vec3 targetCenter = Vec3.m_82512_((Vec3i)bedPos).m_82520_(0.0, 0.1, 0.0);
                this.hamster.m_6034_(targetCenter.f_82479_, targetCenter.f_82480_, targetCenter.f_82481_);
                this.hamster.m_20256_(Vec3.f_82478_);
                this.hamster.f_19812_ = true;
                this.hamster.setDozingPhase(HamsterEntity.DozingPhase.DEEP_SLEEP);
                this.hamster.setSleeping(true);
                this.hamster.m_21837_(true);
                this.world.m_7731_(bedPos, (BlockState)this.world.m_8055_(bedPos).m_61124_((Property)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)), 3);
                this.hamster.startNapTimer();
                BlockEntity be = this.world.m_7702_(bedPos);
                if (be instanceof GeoBlockEntity) {
                    GeoBlockEntity geoBlockEntity = (GeoBlockEntity)be;
                    geoBlockEntity.triggerAnim("hamster_bed_controller", "anim_bed_becoming_occupied");
                }
                this.hamster.startBedSleepEffects();
                if (!(be instanceof HamsterBedBlockEntity)) break;
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.markAsUsed();
            }
        }
    }

    private static enum State {
        MOVING_TO_BED,
        POUNCING_INTO_BED;

    }
}

