/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.announcements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AnnouncementHudRenderer {
    private static final ResourceLocation ICON_TEXTURE = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"textures/item/announcement_bell_icon.png");
    private static final int ICON_WIDTH = 16;
    private static final int ICON_HEIGHT = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GuiGraphics context, float tickDelta) {
        Minecraft client = Minecraft.m_91087_();
        AhpConfig config = Configs.AHP;
        if (!((Boolean)config.enableHudIcon.get()).booleanValue() || client.f_91080_ != null) {
            return;
        }
        List<AnnouncementManager.PendingNotification> notifications = AdorableHamsterPetsClient.getPendingNotifications();
        if (notifications.isEmpty()) {
            return;
        }
        AnnouncementIconAnimator animator = AnnouncementIconAnimator.INSTANCE;
        animator.setHovered(false);
        int screenWidth = context.m_280182_();
        int screenHeight = context.m_280206_();
        animator.updateTargetPosition(screenWidth, screenHeight);
        animator.updateHudPosition(animator.getTargetX(), animator.getTargetY());
        float animScale = animator.getRenderScale(tickDelta);
        float configScale = ((Float)Configs.AHP.hudIconScale.get()).floatValue();
        float finalScale = animScale * configScale;
        float angle = animator.getRenderAngle(tickDelta);
        double renderX = animator.getRenderX(tickDelta);
        double renderY = animator.getRenderY(tickDelta);
        context.m_280168_().m_85836_();
        try {
            context.m_280168_().m_85837_(renderX + 8.0, renderY + 8.0, 0.0);
            context.m_280168_().m_85841_(finalScale, finalScale, 1.0f);
            context.m_280168_().m_252781_(Axis.f_252403_.m_252977_(angle));
            context.m_280168_().m_85837_(-8.0, -8.0, 0.0);
            RenderSystem.enableBlend();
            context.m_280163_(ICON_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        finally {
            context.m_280168_().m_85849_();
        }
        double mouseX = client.f_91067_.m_91589_();
        double mouseY = client.f_91067_.m_91594_();
        if (mouseX >= renderX && mouseX <= renderX + (double)(16.0f * finalScale) && mouseY >= renderY && mouseY <= renderY + (double)(16.0f * finalScale)) {
            ArrayList<Object> tooltipLines = new ArrayList<Object>();
            MutableComponent modNameText = Component.m_237115_((String)"key.categories.adorablehamsterpets.main").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
            AnnouncementManager.PendingNotification primary = notifications.get(0);
            Component mainTooltipLine = AnnouncementManager.getTooltipTextForNotification(primary);
            tooltipLines.add(mainTooltipLine);
            tooltipLines.add(modNameText);
            context.m_280666_(client.f_91062_, tooltipLines, (int)mouseX, (int)mouseY);
        }
    }
}

