/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.handlers;

import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.adastra.common.handlers.base.SpaceStation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class SpaceStationHandler
extends SaveHandler {
    private final Map<UUID, Set<SpaceStation>> spaceStationData = new HashMap<UUID, Set<SpaceStation>>();

    public void loadData(CompoundTag tag) {
        tag.m_128431_().forEach(id -> {
            ListTag stationsTag = tag.m_128437_(id, 10);
            HashSet stations = new HashSet();
            stationsTag.forEach(stationTag -> {
                CompoundTag stationCompoundTag = (CompoundTag)stationTag;
                MutableComponent name = Component.Serializer.m_130701_((String)stationCompoundTag.m_128461_("Name"));
                ChunkPos position = new ChunkPos(stationCompoundTag.m_128454_("Position"));
                stations.add(new SpaceStation(position, (Component)name));
            });
            this.spaceStationData.put(UUID.fromString(id), stations);
        });
    }

    public void saveData(CompoundTag tag) {
        this.spaceStationData.forEach((id, stations) -> {
            ListTag ownerTag = new ListTag();
            for (SpaceStation station : stations) {
                CompoundTag stationsTag = new CompoundTag();
                stationsTag.m_128359_("Name", Component.Serializer.m_130703_((Component)station.name()));
                stationsTag.m_128356_("Position", station.position().m_45588_());
                ownerTag.add((Object)stationsTag);
            }
            tag.m_128365_(id.toString(), (Tag)ownerTag);
        });
    }

    public static SpaceStationHandler read(ServerLevel level) {
        return (SpaceStationHandler)SpaceStationHandler.read((DimensionDataStorage)level.m_8895_(), SpaceStationHandler::new, (String)"adastra_space_station_data");
    }

    public static Map<UUID, Set<SpaceStation>> getAllSpaceStations(ServerLevel level) {
        return SpaceStationHandler.read((ServerLevel)level).spaceStationData;
    }

    public boolean m_77764_() {
        return true;
    }

    public static void constructSpaceStation(ServerPlayer player, ServerLevel level, Component name) {
        Map<UUID, Set<SpaceStation>> data = SpaceStationHandler.read((ServerLevel)level).spaceStationData;
        Set stations = data.computeIfAbsent(player.m_20148_(), k -> new HashSet());
        stations.add(new SpaceStation(player.m_146902_(), name));
    }

    public static boolean isInSpaceStation(ServerPlayer player, ServerLevel level) {
        for (Set<SpaceStation> stations : SpaceStationHandler.read((ServerLevel)level).spaceStationData.values()) {
            for (SpaceStation station : stations) {
                if (station.position().m_45594_(player.m_146902_()) > 2) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<SpaceStation> getOwnedSpaceStations(ServerPlayer player, ServerLevel level) {
        return SpaceStationHandler.getOwnedSpaceStations(player.m_20148_(), level);
    }

    public static Set<SpaceStation> getOwnedSpaceStations(UUID id, ServerLevel level) {
        return SpaceStationHandler.read((ServerLevel)level).spaceStationData.getOrDefault(id, Set.of());
    }
}

