/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities;

import earth.terrarium.adastra.common.blockentities.machines.OxygenDistributorBlockEntity;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import earth.terrarium.adastra.common.tags.ModEntityTypeTags;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AirVortex
extends Entity {
    public static final int LIFE = 600;
    @Nullable
    private final BlockPos source;
    @Nullable
    private final Set<BlockPos> positions;

    public AirVortex(EntityType<?> type, Level level) {
        super(type, level);
        this.m_141960_(EntityInLevelCallback.f_156799_);
        this.source = null;
        this.positions = null;
    }

    public AirVortex(Level level, BlockPos source, Set<BlockPos> positions) {
        super((EntityType)ModEntityTypes.AIR_VORTEX.get(), level);
        this.m_141960_(EntityInLevelCallback.f_156799_);
        this.source = source;
        this.positions = positions;
    }

    public void m_8119_() {
        OxygenDistributorBlockEntity e;
        super.m_8119_();
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (this.source == null || this.positions == null || this.f_19797_ >= 600 || level2.m_8055_(this.source).m_60795_()) {
            this.m_146870_();
            return;
        }
        BlockEntity blockEntity = level2.m_7702_(this.source);
        if (blockEntity instanceof OxygenDistributorBlockEntity && (e = (OxygenDistributorBlockEntity)blockEntity).distributedBlocksCount() < e.distributedBlocksLimit()) {
            this.m_146870_();
            return;
        }
        level2.m_8583_().forEach(entity -> {
            if (entity != null && !entity.m_6095_().m_204039_(ModEntityTypeTags.IGNORES_AIR_VORTEX) && this.positions.contains(entity.m_20183_())) {
                this.applyForce((Entity)entity);
            }
        });
    }

    protected void applyForce(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (player.m_150110_().f_35935_) {
                return;
            }
        }
        int time = this.f_19797_;
        BlockPos targetPosition = this.m_20183_().m_6625_(2);
        double altitude = 1000.0 * Math.exp(-0.005 * (double)time) + 600.0;
        double power = Math.max(0.3, Math.pow(altitude, 2.0) / Math.pow(600.0, 2.0));
        Vec3 scale = Vec3.m_82512_((Vec3i)targetPosition).m_82546_(entity.m_20182_()).m_82541_().m_82490_(power);
        entity.m_5997_(scale.f_82479_, scale.f_82480_, scale.f_82481_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.f_19864_ = true;
        }
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6000_(double x, double y, double z) {
        return false;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }
}

