/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import pyre.tinkerslevellingaddon.ImprovableModifier;
import pyre.tinkerslevellingaddon.command.ModCommands;
import pyre.tinkerslevellingaddon.setup.Registration;
import pyre.tinkerslevellingaddon.util.ModUtil;
import pyre.tinkerslevellingaddon.util.ToolLevellingUtil;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;

public class ExperienceCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").executes(context -> ExperienceCommand.run((CommandContext<CommandSourceStack>)context, ModCommands.Operation.ADD, 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ExperienceCommand.run((CommandContext<CommandSourceStack>)context, ModCommands.Operation.ADD))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> ExperienceCommand.run((CommandContext<CommandSourceStack>)context, ModCommands.Operation.SET)))));
    }

    private static int run(CommandContext<CommandSourceStack> context, ModCommands.Operation op) throws CommandSyntaxException {
        return ExperienceCommand.run(context, op, IntegerArgumentType.getInteger(context, (String)"count"));
    }

    private static int run(CommandContext<CommandSourceStack> context, ModCommands.Operation op, int count) throws CommandSyntaxException {
        List successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            Component error;
            if (ModifierUtil.getModifierLevel((ItemStack)stack, (ModifierId)((ImprovableModifier)Registration.IMPROVABLE.get()).getId()) <= 0) {
                return false;
            }
            ToolStack tool = ToolStack.copyFrom((ItemStack)stack);
            if (op == ModCommands.Operation.ADD) {
                if (!ExperienceCommand.addXp(tool, count, living)) {
                    throw new SimpleCommandExceptionType((Message)ModUtil.makeTranslation("command", "xp.failure.add.already_max_level", stack.m_41611_())).create();
                }
            } else if (!ExperienceCommand.setXp(tool, count, living)) {
                throw new SimpleCommandExceptionType((Message)ModUtil.makeTranslation("command", "xp.failure.set.already_max_level", stack.m_41611_())).create();
            }
            if ((error = tool.tryValidate()) != null) {
                throw ModCommands.TOOL_VALIDATION_ERROR.create((Object)error);
            }
            living.m_21008_(InteractionHand.MAIN_HAND, tool.createStack(stack.m_41613_()));
            return true;
        });
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int size = successes.size();
        if (op == ModCommands.Operation.ADD) {
            if (size == 1) {
                source.m_288197_(() -> ModUtil.makeTranslation("command", "xp.success.add.single", count, ((LivingEntity)successes.get(0)).m_5446_()), true);
            } else {
                source.m_288197_(() -> ModUtil.makeTranslation("command", "xp.success.add.multiple", count, size), true);
            }
        } else if (size == 1) {
            source.m_288197_(() -> ModUtil.makeTranslation("command", "xp.success.set.single", count, ((LivingEntity)successes.get(0)).m_5446_()), true);
        } else {
            source.m_288197_(() -> ModUtil.makeTranslation("command", "xp.success.set.multiple", count, size), true);
        }
        return size;
    }

    private static boolean addXp(ToolStack tool, int count, LivingEntity living) {
        ServerPlayer p;
        ServerPlayer player;
        ServerPlayer serverPlayer = player = living instanceof ServerPlayer ? (p = (ServerPlayer)living) : null;
        if (ToolLevellingUtil.canLevelUp(tool.getPersistentData().getInt(ImprovableModifier.LEVEL_KEY))) {
            ToolLevellingUtil.addExperience(tool, count, player);
            return true;
        }
        return false;
    }

    private static boolean setXp(ToolStack tool, int count, LivingEntity living) {
        ServerPlayer p;
        ServerPlayer player;
        int currentLevel = tool.getPersistentData().getInt(ImprovableModifier.LEVEL_KEY);
        boolean isBroad = ToolLevellingUtil.isBroadTool((IToolStackView)tool);
        ServerPlayer serverPlayer = player = living instanceof ServerPlayer ? (p = (ServerPlayer)living) : null;
        if (ToolLevellingUtil.canLevelUp(currentLevel)) {
            int neededXp = ToolLevellingUtil.getXpNeededForLevel(currentLevel, isBroad);
            int currentXp = tool.getPersistentData().getInt(ImprovableModifier.EXPERIENCE_KEY);
            int xp = Math.max(1, Math.min(count, neededXp - currentXp));
            ToolLevellingUtil.addExperience(tool, xp, player);
            return true;
        }
        return false;
    }
}

