/*
 * Decompiled with CFR 0.152.
 */
package com.cxxxxxlt.tinkers_delight.Modifier;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class SatietyForceModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ProjectileHitModifierHook,
MeleeHitModifierHook {
    private static final Random RANDOM = new Random();
    private static final float BASE_CHANCE = 0.25f;
    private static final float CHANCE_PER_LEVEL = 0.1f;

    private static MobEffectInstance makeStrengthEffect(int level) {
        return new MobEffectInstance(MobEffects.f_19600_, 20 * (5 + RANDOM.nextInt(10)), 0);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged()) {
            Player player;
            int level = modifier.intEffectiveLevel();
            LivingEntity attacker = context.getAttacker();
            if (attacker instanceof Player && (player = (Player)attacker).m_36324_().m_38702_() >= 15 - (level - 1) * 2) {
                float chance = 0.25f + (float)(modifier.getLevel() - 1) * 0.1f;
                if (RANDOM.nextFloat() < chance) {
                    player.m_7292_(SatietyForceModifier.makeStrengthEffect(modifier.getLevel()));
                }
            }
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        int level = modifier.intEffectiveLevel();
        if (attacker instanceof Player) {
            AbstractArrow arrow;
            Player player = (Player)attacker;
            if ((!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_()) && player.m_36324_().m_38702_() >= 15 - (level - 1) * 2) {
                float chance = 0.25f + (float)(modifier.getLevel() - 1) * 0.1f;
                if (RANDOM.nextFloat() < chance) {
                    player.m_7292_(SatietyForceModifier.makeStrengthEffect(modifier.getLevel()));
                }
            }
        }
        return false;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        Player player;
        int level = modifier.intEffectiveLevel();
        if (primary && (arrow == null || arrow.m_36792_()) && shooter instanceof Player && (player = (Player)shooter).m_36324_().m_38702_() >= 15 - (level - 1) * 2) {
            float chance = 0.25f + (float)(modifier.getLevel() - 1) * 0.1f;
            if (RANDOM.nextFloat() < chance) {
                player.m_7292_(SatietyForceModifier.makeStrengthEffect(modifier.getLevel()));
            }
        }
    }
}

