/*
 * Decompiled with CFR 0.152.
 */
package com.cxxxxxlt.tinkers_delight.Modifier;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.tools.modifiers.effect.BleedingEffect;

public class BrittleBonesModifier
extends Modifier
implements ProjectileHitModifierHook,
MeleeHitModifierHook {
    private static final Random RANDOM = new Random();

    private static void applyEffect(LivingEntity target, LivingEntity attacker, int level) {
        float chance = 0.7f - 0.1f * (float)level;
        if (RANDOM.nextFloat() < chance) {
            ((BleedingEffect)TinkerEffects.bleeding.get()).apply(target, 100, 2, true);
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.m_36324_().m_38705_(player.m_36324_().m_38702_() + (1 + level));
            }
        } else {
            ((BleedingEffect)TinkerEffects.bleeding.get()).apply(target, 60, level - 1, true);
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                int hungerConsume = Math.max(0, 5 - level);
                player.m_36324_().m_38705_(player.m_36324_().m_38702_() - hungerConsume);
            }
        }
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        LivingEntity attacker = context.getAttacker();
        if (target != null && context.isFullyCharged() && target.m_6084_()) {
            int level = modifier.getLevel();
            BrittleBonesModifier.applyEffect(target, attacker, level);
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (target != null && (!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_()) && target.m_6084_()) {
            int level = modifier.getLevel();
            BrittleBonesModifier.applyEffect(target, attacker, level);
        }
        return false;
    }
}

