/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.deferred.PotionDeferredRegister;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.shared.TinkerAttributes;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.shared.effect.AntigravityEffect;
import slimeknights.tconstruct.shared.effect.ReturningEffect;
import slimeknights.tconstruct.tools.modifiers.effect.BleedingEffect;
import slimeknights.tconstruct.tools.modifiers.effect.MagneticEffect;
import slimeknights.tconstruct.tools.modifiers.effect.NoMilkEffect;
import slimeknights.tconstruct.tools.modifiers.effect.RepulsiveEffect;
import slimeknights.tconstruct.tools.modifiers.traits.skull.SelfDestructiveModifier;
import slimeknights.tconstruct.world.TinkerWorld;

public class TinkerEffects
extends TinkerModule {
    private static final PotionDeferredRegister POTIONS = new PotionDeferredRegister("tconstruct");
    public static final RegistryObject<TinkerEffect> experienced = MOB_EFFECTS.register("experienced", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 8570995, true).addAttributeModifier((Attribute)TinkerAttributes.EXPERIENCE_MULTIPLIER.get(), "ccffb654-9988-451e-9539-f74934274df1", 0.25, AttributeModifier.Operation.MULTIPLY_BASE));
    public static final RegistryObject<TinkerEffect> ricochet = MOB_EFFECTS.register("ricochet", () -> new TinkerEffect(MobEffectCategory.NEUTRAL, 117709, true).addAttributeModifier((Attribute)TinkerAttributes.KNOCKBACK_MULTIPLIER.get(), "58a4bc13-366f-4f76-82f5-705451498c24", 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
    public static final RegistryObject<TinkerEffect> enderference = MOB_EFFECTS.register("enderference", () -> new TinkerEffect(MobEffectCategory.HARMFUL, 13860095, true));
    public static final RegistryObject<TinkerEffect> bouncy = MOB_EFFECTS.register("bouncy", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 7449699, true).addAttributeModifier((Attribute)TinkerAttributes.BOUNCY.get(), "5de036ed-bc47-4965-9348-64c3ab5c8ae8", 1.0, AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<TinkerEffect> doubleJump = MOB_EFFECTS.register("double_jump", () -> new TinkerEffect(MobEffectCategory.BENEFICIAL, 11115399, true).addAttributeModifier((Attribute)TinkerAttributes.JUMP_COUNT.get(), "9863601a-9d4a-4708-b348-4bf9fe6c0bbd", 1.0, AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<AntigravityEffect> antigravity = MOB_EFFECTS.register("antigravity", AntigravityEffect::new);
    public static final RegistryObject<ReturningEffect> returning = MOB_EFFECTS.register("returning", ReturningEffect::new);
    public static final RegistryObject<BleedingEffect> bleeding = MOB_EFFECTS.register("bleeding", BleedingEffect::new);
    public static final RegistryObject<MagneticEffect> magnetic = MOB_EFFECTS.register("magnetic", MagneticEffect::new);
    public static final RegistryObject<TinkerEffect> selfDestructing = MOB_EFFECTS.register("self_destructing", SelfDestructiveModifier.SelfDestructiveEffect::new);
    public static final RegistryObject<RepulsiveEffect> repulsive = MOB_EFFECTS.register("repulsive", RepulsiveEffect::new);
    public static final RegistryObject<TinkerEffect> pierce = MOB_EFFECTS.register("pierce", () -> new NoMilkEffect(MobEffectCategory.HARMFUL, 13751162, true).addAttributeModifier(Attributes.f_22284_, "cd45be7c-c86f-4a7e-813b-42a44a054f44", -1.0, AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<TinkerEffect> conductive = MOB_EFFECTS.register("conductive", () -> new TinkerEffect(MobEffectCategory.HARMFUL, 15914240, true));
    public static final RegistryObject<TinkerEffect> venom = MOB_EFFECTS.register("venom", () -> new TinkerEffect(MobEffectCategory.HARMFUL, 10654558, true));
    public static final EnumObject<PotionDeferredRegister.PotionType, Potion> experiencedPotion = POTIONS.registerTypes(experienced).withStrong().withLong().build();
    public static final EnumObject<PotionDeferredRegister.PotionType, Potion> ricochetPotion = POTIONS.registerTypes(ricochet).withStrong().withLong().build();
    public static final EnumObject<PotionDeferredRegister.PotionType, Potion> levitationPotion = POTIONS.registerTypes("levitation", () -> MobEffects.f_19620_, 300, 0).withStrong().withLong(800, 0).build();
    public static final EnumObject<PotionDeferredRegister.PotionType, Potion> enderferencePotion = POTIONS.registerTypes(enderference, 1800, 0).withLong().build();

    public TinkerEffects() {
        POTIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TinkerEffects.brewing(experiencedPotion, Potions.f_43602_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH)}));
            TinkerEffects.brewing(ricochetPotion, Potions.f_43602_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY)}));
            TinkerEffects.brewing(levitationPotion, Potions.f_43602_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)}));
            TinkerEffects.brewing(enderferencePotion, Potions.f_43602_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ENDER)}));
        });
    }

    private static void brewing(EnumObject<PotionDeferredRegister.PotionType, Potion> potion, Potion base, Ingredient ingredient) {
        Potion strong;
        Potion normal = (Potion)potion.get((Enum)PotionDeferredRegister.PotionType.NORMAL);
        PotionBrewing.f_43494_.add(new PotionBrewing.Mix(ForgeRegistries.POTIONS, (Object)base, ingredient, (Object)normal));
        Potion longer = (Potion)potion.getOrNull((Enum)PotionDeferredRegister.PotionType.LONG);
        if (longer != null) {
            PotionBrewing.m_43513_((Potion)normal, (Item)Items.f_42451_, (Potion)longer);
        }
        if ((strong = (Potion)potion.getOrNull((Enum)PotionDeferredRegister.PotionType.STRONG)) != null) {
            PotionBrewing.m_43513_((Potion)normal, (Item)Items.f_42525_, (Potion)strong);
        }
    }
}

