/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.melee;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormulaLoadable;
import slimeknights.tconstruct.library.json.variable.melee.MeleeVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record MeleeFormula(ModifierFormula formula, List<MeleeVariable> variables, String[] variableNames, boolean percent) implements VariableFormula<MeleeVariable>
{
    public static final String[] VARIABLES = new String[]{"level", "damage", "multiplier", "base_damage"};
    public static final RecordLoadable<MeleeFormula> LOADER = new VariableFormulaLoadable<MeleeVariable, MeleeFormula>(MeleeVariable.LOADER, VARIABLES, (formula, variables, percent) -> new MeleeFormula((ModifierFormula)formula, (List<MeleeVariable>)variables, EMPTY_STRINGS, (boolean)percent));

    public MeleeFormula(ModifierFormula formula, Map<String, MeleeVariable> variables, boolean percent) {
        this(formula, List.copyOf(variables.values()), VariableFormula.getNames(variables), percent);
    }

    private float[] getArguments(IToolStackView tool, ModifierEntry modifier, @Nullable ToolAttackContext context, @Nullable LivingEntity attacker, float baseDamage, float damage) {
        int size = this.variables.size();
        float[] arguments = VariableFormula.statModuleArguments(size, this.formula.processLevel(modifier), baseDamage, damage, tool.getMultiplier(ToolStats.ATTACK_DAMAGE));
        for (int i = 0; i < size; ++i) {
            arguments[4 + i] = this.variables.get(i).getValue(tool, context, attacker);
        }
        return arguments;
    }

    public float apply(IToolStackView tool, ModifierEntry modifier, @Nullable ToolAttackContext context, @Nullable LivingEntity attacker, float baseDamage, float damage) {
        return this.formula.apply(this.getArguments(tool, modifier, context, attacker, baseDamage, damage));
    }
}

