/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.primitive.ResourceLocationLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.loot.equipment.MobEquipment;

public abstract class AbstractMobEquipmentProvider
extends GenericDataProvider {
    private final Map<String, EquipmentJson> equipment = new HashMap<String, EquipmentJson>();
    private final String modId;

    public AbstractMobEquipmentProvider(PackOutput output, String modId) {
        super(output, PackOutput.Target.DATA_PACK, "tinkering/mob_equipment", JsonHelper.DEFAULT_GSON);
        this.modId = modId;
    }

    protected abstract void addEquipment();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addEquipment();
        return AbstractMobEquipmentProvider.allOf(this.equipment.entrySet().stream().map(entry -> this.saveJson(cache, new ResourceLocation(this.modId, (String)entry.getKey()), ((EquipmentJson)entry.getValue()).serialize())));
    }

    private MobEquipment.Builder equip(String name, ICondition[] conditions, String ... entity) {
        MobEquipment.Builder builder = MobEquipment.builder();
        this.equipment.put(name, new EquipmentJson(entity, builder, conditions));
        return builder;
    }

    public MobEquipment.Builder equip(String name, EntityType<?> entity, ICondition ... conditions) {
        return this.equip(name, conditions, Loadables.ENTITY_TYPE.getString(entity));
    }

    public MobEquipment.Builder equip(EntityType<?> entity, ICondition ... conditions) {
        return this.equip(Loadables.ENTITY_TYPE.getKey(entity).m_135815_(), entity, conditions);
    }

    public MobEquipment.Builder equip(String name, ResourceLocation entity, ICondition ... conditions) {
        return this.equip(name, conditions, entity.toString());
    }

    public MobEquipment.Builder equip(ResourceLocation entity) {
        return this.equip(entity.m_135827_() + "_" + entity.m_135815_(), entity, new ICondition[]{new ModLoadedCondition(entity.m_135827_())});
    }

    public MobEquipment.Builder equip(String name, TagKey<EntityType<?>> tag, ICondition ... conditions) {
        return this.equip(name, conditions, "#" + tag.f_203868_().toString());
    }

    public MobEquipment.Builder equip(TagKey<EntityType<?>> tag, ICondition ... conditions) {
        return this.equip(tag.f_203868_().m_135815_(), tag, conditions);
    }

    public MobEquipment.Builder equip(String name, List<EntityType<?>> entities, ICondition ... conditions) {
        return this.equip(name, conditions, (String[])entities.stream().map(arg_0 -> ((ResourceLocationLoadable)Loadables.ENTITY_TYPE).getString(arg_0)).toArray(String[]::new));
    }

    private record EquipmentJson(String[] entity, MobEquipment.Builder equipment, ICondition[] conditions) {
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            if (this.entity.length == 1) {
                json.addProperty("entity", this.entity[0]);
            } else {
                JsonArray array = new JsonArray();
                for (String s : this.entity) {
                    array.add(s);
                }
                json.add("entity", (JsonElement)array);
            }
            json.add("equip", MobEquipment.LIST_LOADABLE.serialize(this.equipment.build()));
            if (this.conditions.length > 0) {
                json.add("conditions", (JsonElement)CraftingHelper.serialize((ICondition[])this.conditions));
            }
            return json;
        }
    }
}

