/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

@CanIgnoreReturnValue
public abstract class AbstractPartSpriteProvider {
    private final List<PartSpriteInfo.Builder> sprites = new ArrayList<PartSpriteInfo.Builder>();
    @Nullable
    private List<PartSpriteInfo> finalSprites = null;
    private final List<ToolSpriteBuilder> toolSprites = new ArrayList<ToolSpriteBuilder>();
    private final String modID;

    @CheckReturnValue
    public abstract String getName();

    @CheckReturnValue
    protected abstract void addAllSpites();

    protected PartSpriteInfo.Builder addTexture(ResourceLocation sprite, MaterialStatsId ... requiredStats) {
        PartSpriteInfo.Builder builder = new PartSpriteInfo.Builder(sprite, requiredStats);
        this.sprites.add(builder);
        return builder;
    }

    protected PartSpriteInfo.Builder addTexture(String name, MaterialStatsId ... requiredStats) {
        return this.addTexture(new ResourceLocation(this.modID, name), requiredStats);
    }

    protected PartSpriteInfo.Builder addSprite(String name, MaterialStatsId ... requiredStats) {
        return this.addTexture(new ResourceLocation(this.modID, "item/tool/" + name), requiredStats);
    }

    protected PartSpriteInfo.Builder addPart(String name, MaterialStatsId ... requiredStats) {
        return this.addSprite("parts/" + name, requiredStats);
    }

    protected PartSpriteInfo.Builder addHead(String name) {
        return this.addPart(name, HeadMaterialStats.ID);
    }

    protected PartSpriteInfo.Builder addHandle(String name) {
        return this.addPart(name, HandleMaterialStats.ID);
    }

    protected PartSpriteInfo.Builder addBinding(String name) {
        return this.addPart(name, StatlessMaterialStats.BINDING.getIdentifier());
    }

    protected PartSpriteInfo.Builder addLimb(String name) {
        return this.addPart(name, LimbMaterialStats.ID);
    }

    protected PartSpriteInfo.Builder addBowstring(String name) {
        return this.addPart(name, StatlessMaterialStats.BOWSTRING.getIdentifier());
    }

    protected ToolSpriteBuilder buildTool(ResourceLocation name) {
        ToolSpriteBuilder builder = new ToolSpriteBuilder(name);
        this.toolSprites.add(builder);
        return builder;
    }

    protected ToolSpriteBuilder buildTool(String name) {
        return this.buildTool(new ResourceLocation(this.modID, name));
    }

    public List<PartSpriteInfo> getSprites() {
        if (this.finalSprites == null) {
            this.addAllSpites();
            this.toolSprites.forEach(ToolSpriteBuilder::build);
            this.toolSprites.clear();
            this.finalSprites = this.sprites.stream().map(PartSpriteInfo.Builder::build).toList();
        }
        return this.finalSprites;
    }

    public void cleanCache() {
        this.sprites.clear();
        this.toolSprites.clear();
        this.finalSprites = null;
    }

    public AbstractPartSpriteProvider(String modID) {
        this.modID = modID;
    }

    public static class PartSpriteInfo {
        public static final RecordLoadable<PartSpriteInfo> LOADABLE = RecordLoadable.create((RecordField)Loadables.RESOURCE_LOCATION.requiredField("path", i -> i.path), (RecordField)MaterialStatsId.PARSER.set(-1).requiredField("stat_type", i -> i.statTypes), (RecordField)BooleanLoadable.INSTANCE.defaultField("allow_animated", (Object)true, false, i -> i.allowAnimated), (RecordField)BooleanLoadable.INSTANCE.defaultField("skip_variants", (Object)false, false, i -> i.skipVariants), PartSpriteInfo::new);
        public static final Loadable<List<PartSpriteInfo>> LIST_LOADABLE = LOADABLE.list(1);
        private final ResourceLocation path;
        private final Set<MaterialStatsId> statTypes;
        private final boolean allowAnimated;
        private final boolean skipVariants;
        private final transient Map<String, NativeImage> sprites = new HashMap<String, NativeImage>();

        @Nullable
        public NativeImage getTexture(AbstractSpriteReader spriteReader, String name) {
            if (this.sprites.containsKey(name)) {
                return this.sprites.get(name);
            }
            ResourceLocation fallbackPath = this.path;
            if (!name.isEmpty()) {
                fallbackPath = new ResourceLocation(this.path.m_135827_(), this.path.m_135815_() + "_" + name);
            }
            NativeImage image = spriteReader.readIfExists(fallbackPath);
            this.sprites.put(name, image);
            return image;
        }

        public PartSpriteInfo(ResourceLocation path, Set<MaterialStatsId> statTypes, boolean allowAnimated, boolean skipVariants) {
            this.path = path;
            this.statTypes = statTypes;
            this.allowAnimated = allowAnimated;
            this.skipVariants = skipVariants;
        }

        public ResourceLocation getPath() {
            return this.path;
        }

        public Set<MaterialStatsId> getStatTypes() {
            return this.statTypes;
        }

        public boolean isAllowAnimated() {
            return this.allowAnimated;
        }

        public boolean isSkipVariants() {
            return this.skipVariants;
        }

        @CanIgnoreReturnValue
        public static class Builder {
            private final ResourceLocation path;
            private final Set<MaterialStatsId> statTypes;
            private boolean allowAnimated = true;
            private boolean skipVariants = false;

            private Builder(ResourceLocation path, MaterialStatsId[] requiredStats) {
                this.path = path;
                this.statTypes = ImmutableSet.copyOf((Object[])requiredStats);
            }

            public Builder disallowAnimated() {
                return this.allowAnimated(false);
            }

            public Builder skipVariants() {
                return this.skipVariants(true);
            }

            @CheckReturnValue
            private PartSpriteInfo build() {
                return new PartSpriteInfo(this.path, this.statTypes, this.allowAnimated, this.skipVariants);
            }

            private Builder allowAnimated(boolean allowAnimated) {
                this.allowAnimated = allowAnimated;
                return this;
            }

            private Builder skipVariants(boolean skipVariants) {
                this.skipVariants = skipVariants;
                return this;
            }
        }
    }

    protected class ToolSpriteBuilder {
        private final ResourceLocation name;
        private final Map<String, MaterialStatsId[]> parts = new LinkedHashMap<String, MaterialStatsId[]>();
        private boolean hasLarge = false;
        private boolean allowAnimated = true;
        private boolean skipVariants = false;

        public ToolSpriteBuilder withLarge() {
            this.hasLarge = true;
            return this;
        }

        public ToolSpriteBuilder disallowAnimated() {
            this.allowAnimated = false;
            return this;
        }

        public ToolSpriteBuilder skipVariants() {
            this.skipVariants = true;
            return this;
        }

        public ToolSpriteBuilder addPart(String name, MaterialStatsId ... statTypes) {
            this.parts.put(name, statTypes);
            return this;
        }

        public ToolSpriteBuilder addPart(String name, IMaterialStats statType) {
            return this.addPart(name, statType.getIdentifier());
        }

        public ToolSpriteBuilder addBreakablePart(String name, MaterialStatsId ... statTypes) {
            this.addPart(name, statTypes);
            this.addPart(name + "_broken", statTypes);
            return this;
        }

        public ToolSpriteBuilder addBreakablePart(String name, IMaterialStats statType) {
            return this.addBreakablePart(name, statType.getIdentifier());
        }

        public ToolSpriteBuilder addHead(String name) {
            return this.addPart(name, HeadMaterialStats.ID);
        }

        public ToolSpriteBuilder addBreakableHead(String name) {
            return this.addBreakablePart(name, HeadMaterialStats.ID);
        }

        public ToolSpriteBuilder addHandle(String name) {
            return this.addPart(name, HandleMaterialStats.ID);
        }

        public ToolSpriteBuilder addBinding(String name) {
            return this.addPart(name, StatlessMaterialStats.BINDING);
        }

        public ToolSpriteBuilder addLimb(String name) {
            return this.addPart(name, LimbMaterialStats.ID);
        }

        public ToolSpriteBuilder addGrip(String name) {
            return this.addPart(name, GripMaterialStats.ID);
        }

        public ToolSpriteBuilder addBowstring(String name) {
            return this.addPart(name, StatlessMaterialStats.BOWSTRING);
        }

        public ToolSpriteBuilder addBreakableBowstring(String name) {
            return this.addBreakablePart(name, StatlessMaterialStats.BOWSTRING);
        }

        public ToolSpriteBuilder addArrowHead(String name) {
            return this.addPart(name, StatlessMaterialStats.ARROW_HEAD);
        }

        private void addParts(String path) {
            for (Map.Entry<String, MaterialStatsId[]> entry : this.parts.entrySet()) {
                AbstractPartSpriteProvider.this.addTexture(new ResourceLocation(this.name.m_135827_(), "item/tool/" + path + "/" + entry.getKey()), entry.getValue()).allowAnimated(this.allowAnimated).skipVariants(this.skipVariants);
            }
        }

        private void build() {
            this.addParts(this.name.m_135815_());
            if (this.hasLarge) {
                this.addParts(this.name.m_135815_() + "/large");
            }
        }

        private ToolSpriteBuilder(ResourceLocation name) {
            this.name = name;
        }
    }
}

