/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import mekanism.additions.client.model.AdditionsModelCache;
import mekanism.additions.common.MekanismAdditions;
import mekanism.additions.common.entity.EntityBalloon;
import mekanism.api.text.EnumColor;
import mekanism.client.model.BaseModelCache;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RenderBalloon
extends EntityRenderer<EntityBalloon> {
    public static final ResourceLocation BALLOON_TEXTURE = MekanismAdditions.rl("textures/item/balloon.png");

    public RenderBalloon(EntityRendererProvider.Context context) {
        super(context);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityBalloon entity) {
        return BALLOON_TEXTURE;
    }

    public void render(@NotNull EntityBalloon balloon, float entityYaw, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light) {
        matrix.m_85836_();
        matrix.m_85837_(-0.5, -1.0, -0.5);
        if (balloon.isLatchedToEntity()) {
            double x = balloon.latchedEntity.f_19790_ + (balloon.latchedEntity.m_20185_() - balloon.latchedEntity.f_19790_) * (double)partialTick - (balloon.f_19790_ + (balloon.m_20185_() - balloon.f_19790_) * (double)partialTick);
            double y = balloon.latchedEntity.f_19791_ + (balloon.latchedEntity.m_20186_() - balloon.latchedEntity.f_19791_) * (double)partialTick - (balloon.f_19791_ + (balloon.m_20186_() - balloon.f_19791_) * (double)partialTick) + balloon.getAddedHeight();
            double z = balloon.latchedEntity.f_19792_ + (balloon.latchedEntity.m_20189_() - balloon.latchedEntity.f_19792_) * (double)partialTick - (balloon.f_19792_ + (balloon.m_20189_() - balloon.f_19792_) * (double)partialTick);
            matrix.m_85837_(x, y, z);
        }
        BaseModelCache.JSONModelData model = balloon.isLatched() ? AdditionsModelCache.INSTANCE.BALLOON : AdditionsModelCache.INSTANCE.BALLOON_FREE;
        List quads = model.getQuads(balloon.m_9236_().f_46441_);
        RenderType renderType = RenderType.m_110473_((ResourceLocation)TextureAtlas.f_118259_);
        VertexConsumer builder = renderer.m_6299_(renderType);
        PoseStack.Pose last = matrix.m_85850_();
        for (BakedQuad quad : quads) {
            float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            if (quad.m_111305_() == 0) {
                EnumColor balloonColor = balloon.getColor();
                color[0] = balloonColor.getColor(0);
                color[1] = balloonColor.getColor(1);
                color[2] = balloonColor.getColor(2);
            }
            builder.putBulkData(last, quad, color[0], color[1], color[2], color[3], light, OverlayTexture.f_118083_, false);
        }
        matrix.m_85849_();
        super.m_7392_((Entity)balloon, entityYaw, partialTick, matrix, renderer, light);
    }
}

