/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radial.data;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mekanism.api.IDisableableEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.radial.ClassBasedRadialData;
import mekanism.api.radial.mode.IRadialMode;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class DisableableEnumRadialData<MODE extends Enum<MODE> & IRadialMode>
extends ClassBasedRadialData<MODE> {
    private final MODE[] modes;
    @Nullable
    private final MODE defaultMode;

    DisableableEnumRadialData(ResourceLocation identifier, MODE defaultMode) {
        super(identifier, ((Enum)Objects.requireNonNull(defaultMode, "Default mode cannot be null.")).getDeclaringClass());
        this.modes = (Enum[])this.clazz.getEnumConstants();
        this.defaultMode = defaultMode;
    }

    DisableableEnumRadialData(ResourceLocation identifier, Class<MODE> enumClass) {
        super(identifier, enumClass);
        this.modes = (Enum[])this.clazz.getEnumConstants();
        this.defaultMode = this.modes.length == 0 ? null : this.modes[0];
    }

    @Override
    @Nullable
    public MODE getDefaultMode(List<MODE> modes) {
        return this.defaultMode;
    }

    @Override
    public List<MODE> getModes() {
        return Arrays.stream(this.modes).filter(rec$ -> ((IDisableableEnum)rec$).isEnabled()).toList();
    }

    @Override
    public int index(List<MODE> modes, MODE mode) {
        if (modes.size() == this.modes.length) {
            return ((Enum)mode).ordinal();
        }
        return super.index(modes, mode);
    }

    @Override
    public int getNetworkRepresentation(MODE mode) {
        return ((IDisableableEnum)mode).isEnabled() ? ((Enum)mode).ordinal() : -1;
    }

    @Override
    @Nullable
    public MODE fromNetworkRepresentation(int networkRepresentation) {
        Enum mode = (Enum)MathUtils.getByIndexMod(this.modes, networkRepresentation);
        return (MODE)(((IDisableableEnum)((Object)mode)).isEnabled() ? mode : this.defaultMode);
    }
}

