/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.mantle.util.RegistryHelper;

public class TagPreference {
    private static final ResourceLocation DEFAULT_ID = new ResourceLocation("zzzzz:zzzzz");
    private static final Map<TagKey<?>, Optional<?>> PREFERENCE_CACHE = new ConcurrentHashMap();
    private static final Map<ResourceKey<?>, Comparator<?>> COMPARATOR_CACHE = new ConcurrentHashMap();
    private static final Function<TagKey<?>, Optional<?>> PREFERENCE_LOOKUP;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TagsUpdatedEvent.class, e -> PREFERENCE_CACHE.clear());
    }

    private static <T> Comparator<T> getComparator(Registry<T> registry) {
        return COMPARATOR_CACHE.computeIfAbsent(registry.m_123023_(), k -> new RegistryComparator(registry));
    }

    private static <T> Optional<T> getUncachedPreference(TagKey<T> tag) {
        Registry registry = RegistryHelper.getRegistry(tag.f_203867_());
        if (registry == null) {
            return Optional.empty();
        }
        return RegistryHelper.getTagValueStream(registry, tag).min(TagPreference.getComparator(registry));
    }

    public static <T> Optional<T> getPreference(TagKey<T> tag) {
        return PREFERENCE_CACHE.computeIfAbsent(tag, PREFERENCE_LOOKUP);
    }

    static {
        COMPARATOR_CACHE.put(Registries.f_256808_, FluidComparator.INSTANCE);
        PREFERENCE_LOOKUP = TagPreference::getUncachedPreference;
    }

    private record RegistryComparator<T>(Registry<T> registry) implements Comparator<T>
    {
        @Override
        public int compare(T a, T b) {
            int indexB;
            ResourceLocation idA = Objects.requireNonNullElse(this.registry.m_7981_(a), DEFAULT_ID);
            ResourceLocation idB = Objects.requireNonNullElse(this.registry.m_7981_(b), DEFAULT_ID);
            List entries = (List)Config.TAG_PREFERENCES.get();
            int size = entries.size();
            int indexA = LogicHelper.defaultIf(entries.indexOf(idA.m_135827_()), -1, size);
            if (indexA != (indexB = LogicHelper.defaultIf(entries.indexOf(idB.m_135827_()), -1, size))) {
                return Integer.compare(indexA, indexB);
            }
            return idA.compareNamespaced(idB);
        }
    }

    private static enum FluidComparator implements Comparator<Fluid>
    {
        INSTANCE;

        private final Comparator<Fluid> preference = new RegistryComparator<Fluid>((Registry<Fluid>)BuiltInRegistries.f_257020_);

        @Override
        public int compare(Fluid fluid1, Fluid fluid2) {
            boolean isSource1 = fluid1.m_7444_(fluid1.m_76145_());
            if (isSource1 != fluid2.m_7444_(fluid2.m_76145_())) {
                return isSource1 ? -1 : 1;
            }
            return this.preference.compare(fluid1, fluid2);
        }
    }
}

