/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.util.JsonHelper;

public record TagCombinationCondition<T>(List<TagKey<T>> match, @Nullable TagKey<T> ignore) implements ICondition
{
    public static final ResourceLocation ID = Mantle.getResource("tag_combination_filled");
    public static final IConditionSerializer<TagCombinationCondition<?>> SERIALIZER = new IConditionSerializer<TagCombinationCondition<?>>(){
        private static final Loadable<List<ResourceLocation>> MATCH = Loadables.RESOURCE_LOCATION.list(-1);

        public ResourceLocation getID() {
            return ID;
        }

        public void write(JsonObject json, TagCombinationCondition<?> value) {
            ResourceKey registry = value.match.get(0).f_203867_();
            if (!Registries.f_256913_.equals((Object)registry)) {
                json.addProperty("registry", registry.m_135782_().toString());
            }
            if (value.match.size() == 1) {
                json.addProperty("match", value.match.get(0).f_203868_().toString());
            } else {
                JsonArray names = new JsonArray();
                for (TagKey name : value.match) {
                    names.add(name.f_203868_().toString());
                }
                json.add("match", (JsonElement)names);
            }
            if (value.ignore != null) {
                json.addProperty("ignore", value.ignore.f_203868_().toString());
            }
        }

        public TagCombinationCondition<?> read(JsonObject json) {
            ResourceKey registry = ResourceKey.m_135788_((ResourceLocation)JsonHelper.getResourceLocation(json, "registry", Registries.f_256913_.m_135782_()));
            return new TagCombinationCondition(MATCH.getIfPresent(json, "match").stream().map(id -> TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)id)).toList(), json.has("ignore") ? TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)JsonHelper.getResourceLocation(json, "ignore")) : null);
        }
    };

    public TagCombinationCondition {
        if (match.isEmpty()) {
            throw new IllegalArgumentException("Must match at least 1 tag");
        }
    }

    @SafeVarargs
    public static <T> TagCombinationCondition<T> match(@Nullable TagKey<T> ignore, TagKey<T> ... match) {
        return new TagCombinationCondition<T>(List.of(match), ignore);
    }

    @SafeVarargs
    public static <T> TagCombinationCondition<T> intersection(TagKey<T> ... match) {
        return TagCombinationCondition.match(null, match);
    }

    public static <T> TagCombinationCondition<T> difference(TagKey<T> match, TagKey<T> ignore) {
        return TagCombinationCondition.match(ignore, match);
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        List ignored;
        List<Collection> tags = this.match.stream().map(arg_0 -> ((ICondition.IContext)context).getTag(arg_0)).toList();
        Collection collection = ignored = this.ignore == null ? List.of() : context.getTag(this.ignore);
        if (tags.size() == 1 && ignored.isEmpty()) {
            return !tags.get(0).isEmpty();
        }
        int count = tags.size();
        for (int i = 1; i < count; ++i) {
            if (!tags.get(i).isEmpty()) continue;
            return false;
        }
        block1: for (Holder entry : tags.get(0)) {
            if (ignored.contains(entry)) continue;
            for (int i = 1; i < count; ++i) {
                if (!tags.get(i).contains(entry)) continue block1;
            }
            return true;
        }
        return false;
    }
}

