/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command.tags;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.GeneratePackHelper;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.argument.ResourceOrTagKeyArgument;
import slimeknights.mantle.command.argument.TagSource;
import slimeknights.mantle.command.argument.TagSourceArgument;
import slimeknights.mantle.util.JsonHelper;

public class ModifyTagCommand {
    private static final Dynamic2CommandExceptionType ERROR_READING_TAG = new Dynamic2CommandExceptionType((type, name) -> Component.m_237110_((String)"command.mantle.modify_tag.read_error", (Object[])new Object[]{type, name}));
    private static final Dynamic2CommandExceptionType ERROR_WRITING_TAG = new Dynamic2CommandExceptionType((type, name) -> Component.m_237110_((String)"command.mantle.modify_tag.write_error", (Object[])new Object[]{type, name}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then(Action.ADD.build())).then(Action.REMOVE.build())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(source -> MantleCommand.requiresDebugInfoOrOp(source, 2))).then(TagSourceArgument.argument().then(TagSourceArgument.tagArgument("tag").executes(context -> ModifyTagCommand.clear((CommandContext<CommandSourceStack>)context, TagSourceArgument.get((CommandContext<? extends SharedSuggestionProvider>)context))))));
    }

    private static void saveTag(ResourceLocation regName, ResourceLocation tag, Path path, TagFile contents) throws CommandSyntaxException {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(JsonHelper.DEFAULT_GSON.toJson(JsonHelper.serialize(TagFile.f_215958_, contents)));
            }
        }
        catch (IOException ex) {
            Mantle.logger.error("Couldn't save {} tag {} to {}", (Object)regName, (Object)tag, (Object)path, (Object)ex);
            throw ERROR_WRITING_TAG.create((Object)regName, (Object)tag);
        }
    }

    private static Path getPath(Path pack, TagSource<?> registry, ResourceLocation tag) {
        return pack.resolve(PackType.SERVER_DATA.m_10305_() + "/" + tag.m_135827_() + "/" + registry.folder() + "/" + tag.m_135815_() + ".json");
    }

    private static Component tagComponent(ResourceLocation tag, Path path) {
        return GeneratePackHelper.getPathComponent(Component.m_237113_((String)tag.toString()), path.toString());
    }

    private static <T> int modify(CommandContext<CommandSourceStack> context, TagSource<T> registry, Action action) throws CommandSyntaxException {
        ResourceLocation regName = registry.key().m_135782_();
        ResourceLocation tag = (ResourceLocation)context.getArgument("tag", ResourceLocation.class);
        ResourceOrTagKeyArgument.Result entry = ResourceOrTagKeyArgument.get(context, "entry");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Path pack = GeneratePackHelper.getDatapackPath(source.m_81377_());
        GeneratePackHelper.saveMcmeta(pack);
        Path tagPath = ModifyTagCommand.getPath(pack, registry, tag);
        ArrayList<TagEntry> add = new ArrayList<TagEntry>();
        ArrayList<TagEntry> remove = new ArrayList<TagEntry>();
        boolean replace = false;
        if (Files.exists(tagPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(tagPath);){
                TagFile tagfile = (TagFile)JsonHelper.parse(TagFile.f_215958_, reader);
                add.addAll(tagfile.f_215959_());
                remove.addAll(tagfile.remove());
                replace = tagfile.f_215960_();
            }
            catch (Exception e) {
                Mantle.logger.error("Failed to load {} tag {} from {}", (Object)regName, (Object)tag, (Object)tagPath, (Object)e);
                throw ERROR_READING_TAG.create((Object)regName, (Object)tag);
            }
        }
        TagEntry tagEntry = entry.tagEntry();
        int changed = 0;
        if (action == Action.ADD) {
            if (ModifyTagCommand.remove(remove, tagEntry)) {
                ++changed;
            }
            if (ModifyTagCommand.add(add, tagEntry)) {
                ++changed;
            }
        } else {
            if (ModifyTagCommand.remove(add, tagEntry)) {
                ++changed;
            }
            if (ModifyTagCommand.add(remove, tagEntry)) {
                ++changed;
            }
        }
        if (changed > 0) {
            ModifyTagCommand.saveTag(regName, tag, tagPath, new TagFile(add, replace, remove));
        }
        source.m_288197_(() -> Component.m_237110_((String)("command.mantle.modify_tag.success." + action.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{entry, regName, ModifyTagCommand.tagComponent(tag, tagPath), GeneratePackHelper.getOutputComponent(pack)}), true);
        return changed;
    }

    private static <T> int clear(CommandContext<CommandSourceStack> context, TagSource<T> registry) throws CommandSyntaxException {
        ResourceLocation regName = registry.key().m_135782_();
        ResourceLocation tag = (ResourceLocation)context.getArgument("tag", ResourceLocation.class);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Path pack = GeneratePackHelper.getDatapackPath(source.m_81377_());
        GeneratePackHelper.saveMcmeta(pack);
        Path tagPath = ModifyTagCommand.getPath(pack, registry, tag);
        ModifyTagCommand.saveTag(regName, tag, tagPath, new TagFile(List.of(), true, List.of()));
        source.m_288197_(() -> Component.m_237110_((String)"command.mantle.modify_tag.success.clear", (Object[])new Object[]{regName, ModifyTagCommand.tagComponent(tag, tagPath), GeneratePackHelper.getOutputComponent(pack)}), true);
        return 0;
    }

    private static boolean equals(TagEntry left, TagEntry right) {
        return left.isTag() == right.isTag() && left.isRequired() == right.isRequired() && left.getId().equals((Object)right.getId());
    }

    private static boolean remove(List<TagEntry> entries, TagEntry toRemove) {
        Iterator<TagEntry> iterator = entries.iterator();
        while (iterator.hasNext()) {
            TagEntry entry = iterator.next();
            if (!ModifyTagCommand.equals(entry, toRemove)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private static boolean add(List<TagEntry> entries, TagEntry toAdd) {
        for (TagEntry entry : entries) {
            if (!ModifyTagCommand.equals(entry, toAdd)) continue;
            return false;
        }
        entries.add(toAdd);
        return true;
    }

    private static enum Action {
        ADD,
        REMOVE;


        public ArgumentBuilder<CommandSourceStack, ?> build() {
            return ((LiteralArgumentBuilder)Commands.m_82127_((String)this.name().toLowerCase(Locale.ROOT)).requires(source -> MantleCommand.requiresDebugInfoOrOp(source, 2))).then(TagSourceArgument.argument().then(TagSourceArgument.tagArgument("tag").then(TagSourceArgument.entryArgument("entry").executes(context -> ModifyTagCommand.modify((CommandContext<CommandSourceStack>)context, TagSourceArgument.get((CommandContext<? extends SharedSuggestionProvider>)context), this)))));
        }
    }
}

