/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.entity.custom.leviathan.goal;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.multipart_entities.util.CompoundOrientedBox;
import com.cerbon.cerbons_api.api.multipart_entities.util.OrientedBox;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.LeviathanEntity;
import com.cerbon.myths_of_the_sea.util.MTSUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class LeviathanMeleeAttackGoal
extends MeleeAttackGoal {
    private final LeviathanEntity leviathan;
    private final int cooldownBetweenAttacks;

    public LeviathanMeleeAttackGoal(LeviathanEntity pathfinderMob, double speedModifier, boolean followingTargetEvenIfNotSeen, int cooldownBetweenAttacks) {
        super((PathfinderMob)pathfinderMob, speedModifier, followingTargetEvenIfNotSeen);
        this.leviathan = pathfinderMob;
        this.cooldownBetweenAttacks = cooldownBetweenAttacks;
    }

    public boolean m_8045_() {
        return super.m_8045_() && !this.leviathan.hasAttackedOnWater;
    }

    public boolean m_8036_() {
        return super.m_8036_() && !this.leviathan.hasAttackedOnWater;
    }

    protected void m_6739_(@NotNull LivingEntity enemy, double distToEnemySqr) {
        double d = this.m_6639_(enemy);
        if (distToEnemySqr <= d && this.m_25565_() <= 0 && this.leviathan.isSeeingTarget(enemy)) {
            this.leviathan.m_6674_(InteractionHand.MAIN_HAND);
            CapabilityUtils.getLevelEventScheduler((Level)this.leviathan.m_9236_()).addEvent((IEvent)new TimedEvent(() -> {
                MTSUtils.pounceAtTarget((LivingEntity)this.leviathan, enemy, 0.3f, 0.1f);
                double newDistToEnemySqr = this.leviathan.m_262793_(enemy);
                double d1 = this.m_6639_(enemy);
                if (newDistToEnemySqr <= d1 && this.m_25565_() <= 0) {
                    this.m_25563_();
                    this.leviathan.m_7327_((Entity)enemy);
                    this.leviathan.setLastPrey((Entity)enemy);
                    this.leviathan.setLastPreyUUID(enemy.m_20148_());
                }
            }, 15, () -> ((LeviathanEntity)this.leviathan).m_21224_()));
            this.leviathan.cooldownSwimmingAttackTicks = this.cooldownBetweenAttacks + this.leviathan.m_217043_().m_216332_(0, 100);
            this.leviathan.hasAttackedOnWater = true;
        }
    }

    protected double m_6639_(@NotNull LivingEntity attackTarget) {
        CompoundOrientedBox compound = this.leviathan.getCompoundBoundingBox(this.leviathan.m_20191_());
        double definitiveMaxSize = 0.0;
        for (OrientedBox orientedBox : compound) {
            AABB extents = orientedBox.getExtents();
            double xSize = extents.f_82291_ - extents.f_82288_;
            double zSize = extents.f_82293_ - extents.f_82290_;
            double maxSize = Math.max(xSize, zSize);
            definitiveMaxSize = Math.max(maxSize, definitiveMaxSize);
        }
        return this.leviathan.m_20205_() * 0.6f * this.leviathan.m_20205_() * 0.6f + attackTarget.m_20205_();
    }
}

