/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.FluidTextHelper;

public class FluidView {
    public static final Component EMPTY_FLUID = Component.m_237115_((String)"jade.fluid.empty");
    public IElement overlay;
    public String current;
    public String max;
    public float ratio;
    @Nullable
    public Component fluidName;
    @Nullable
    public Component overrideText;

    public FluidView(IElement overlay) {
        this.overlay = overlay;
        Objects.requireNonNull(overlay);
    }

    @Nullable
    public static FluidView readDefault(CompoundTag tag) {
        long capacity = tag.m_128454_("capacity");
        if (capacity <= 0L) {
            return null;
        }
        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(tag.m_128461_("fluid")));
        CompoundTag nbt = tag.m_128441_("tag") ? tag.m_128469_("tag") : null;
        long amount = tag.m_128454_("amount");
        JadeFluidObject fluidObject = JadeFluidObject.of(fluid, amount, nbt);
        FluidView fluidView = new FluidView(IElementHelper.get().fluid(fluidObject));
        fluidView.fluidName = CommonProxy.getFluidName(fluidObject);
        fluidView.current = FluidTextHelper.getUnicodeMillibuckets(amount, true);
        fluidView.max = FluidTextHelper.getUnicodeMillibuckets(capacity, true);
        fluidView.ratio = (float)((double)amount / (double)capacity);
        if (fluidObject.getType().m_6212_(Fluids.f_76191_)) {
            fluidView.overrideText = Component.m_237110_((String)"jade.fluid", (Object[])new Object[]{EMPTY_FLUID, Component.m_237113_((String)fluidView.max).m_130940_(ChatFormatting.GRAY)});
        }
        return fluidView;
    }

    public static CompoundTag writeDefault(JadeFluidObject fluidObject, long capacity) {
        CompoundTag tag = new CompoundTag();
        if (capacity <= 0L) {
            return tag;
        }
        tag.m_128359_("fluid", BuiltInRegistries.f_257020_.m_7981_((Object)fluidObject.getType()).toString());
        tag.m_128356_("amount", fluidObject.getAmount());
        tag.m_128356_("capacity", capacity);
        if (fluidObject.getTag() != null) {
            tag.m_128365_("tag", (Tag)fluidObject.getTag());
        }
        return tag;
    }
}

