/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing;

import com.mojang.brigadier.CommandDispatcher;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import fr.iglee42.createcasing.CreateCasingClient;
import fr.iglee42.createcasing.commands.CreateCasingCommand;
import fr.iglee42.createcasing.config.ModConfigs;
import fr.iglee42.createcasing.registries.EncasedBlockEntities;
import fr.iglee42.createcasing.registries.EncasedBlocks;
import fr.iglee42.createcasing.registries.EncasedCreativeModeTabs;
import fr.iglee42.createcasing.registries.EncasedPackets;
import fr.iglee42.createcasing.registries.EncasedSounds;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="createcasing")
public class CreateCasing {
    public static final String MODID = "createcasing";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"createcasing");
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"createcasing").defaultCreativeTab((ResourceKey)null);
    public static List<ItemLike> hidedItems = new ArrayList<ItemLike>();

    public CreateCasing() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modEventBus);
        EncasedSounds.prepare();
        EncasedBlocks.register();
        EncasedBlockEntities.register();
        EncasedCreativeModeTabs.register(modEventBus);
        EncasedPackets.registerPackets();
        EncasedBlocks.registerEncasedShafts();
        ModConfigs.register(ModLoadingContext.get());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateCasingClient.onCtorClient(modEventBus));
        forgeEventBus.addListener(this::registerCommands);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(EncasedSounds::register);
        modEventBus.addListener(EventPriority.LOWEST, this::gatherData);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static void hideItem(ItemLike it) {
        hidedItems.add(it);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void registerCommands(RegisterCommandsEvent event) {
        if (!FMLEnvironment.production) {
            new CreateCasingCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    private void gatherData(GatherDataEvent event) {
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

